/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.eye;

import club.sk1er.mods.eye.Command20Config;
import club.sk1er.mods.eye.Config;
import club.sk1er.mods.eye.ConfigGui;
import club.sk1er.mods.eye.utils.Multithreading;
import club.sk1er.mods.eye.utils.Sk1erMod;
import com.google.gson.Gson;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.FileUtils;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@Mod(modid="20_20_20", name="20 20 20", version="1.2", acceptedMinecraftVersions="[1.8.9]")
public class TwentyTwentyTwentyMod {
    public static final String MODID = "20_20_20";
    public static final String VERSION = "1.2";
    private final Gson gson = new Gson();
    private Config config;
    private ResourceLocation textureLoc = new ResourceLocation("20_20_20", "break.png");
    private KeyBinding keyBinding = new KeyBinding("Start Break", 36, "20 20 20");
    private Sk1erMod sk1erMod;
    private int breakTicks;
    private int ticks;
    private boolean breaking;
    private boolean timeForBreak;
    private int warnedTicks;

    public Config getConfig() {
        return this.config;
    }

    @Mod.EventHandler
    public void init(FMLPreInitializationEvent event) {
        File suggestedConfigurationFile = event.getSuggestedConfigurationFile();
        try {
            this.config = (Config)this.gson.fromJson(FileUtils.readFileToString((File)suggestedConfigurationFile, (String)"UTF-8"), Config.class);
        }
        catch (Exception e) {
            System.out.println("No config file");
        }
        if (this.config == null) {
            this.config = new Config();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                FileUtils.write((File)suggestedConfigurationFile, (CharSequence)this.gson.toJson((Object)this.config));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientRegistry.registerKeyBinding((KeyBinding)this.keyBinding);
        this.sk1erMod = new Sk1erMod(MODID, VERSION, "20 20 20");
        this.sk1erMod.checkStatus();
        ClientCommandHandler.instance.func_71560_a((ICommand)new Command20Config(this));
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP thePlayer = Minecraft.func_71410_x().field_71439_g;
        if (!this.config.isEnabled() || event.phase != TickEvent.Phase.START || thePlayer == null) {
            return;
        }
        boolean bl = this.timeForBreak = ++this.ticks >= this.config.getInterval() * 20 * 60;
        if (this.timeForBreak) {
            if (this.warnedTicks % 600 == 0 && this.config.isChat()) {
                this.sk1erMod.sendMessage("Time to take a break. Press " + Keyboard.getKeyName((int)this.keyBinding.func_151463_i()) + " to start. ");
                if (this.config.isPingWhenReady()) {
                    this.ping();
                }
            }
            ++this.warnedTicks;
        }
        if (this.keyBinding.func_151468_f()) {
            if (this.breaking) {
                this.breaking = false;
            } else {
                this.ticks = 0;
                this.breaking = true;
                this.breakTicks = 0;
                this.warnedTicks = 0;
            }
        }
        if (this.breaking) {
            this.timeForBreak = false;
            ++this.breakTicks;
            if (this.breakTicks > this.config.getDuration() * 20) {
                this.breaking = false;
                if (this.config.isPingWhenDone()) {
                    this.ping();
                }
            }
        }
    }

    private void ping() {
        SoundHandler soundHandler = Minecraft.func_71410_x().func_147118_V();
        if (soundHandler != null && Minecraft.func_71410_x().field_71441_e != null) {
            Multithreading.runAsync(() -> {
                long[] times;
                for (long time : times = new long[]{0L, 50L, 50L, 50L, 400L, 100L, 100L}) {
                    try {
                        Thread.sleep(time);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    soundHandler.func_147682_a((ISound)PositionedSoundRecord.func_147675_a((ResourceLocation)new ResourceLocation("note.pling"), (float)((float)Minecraft.func_71410_x().field_71439_g.field_70165_t), (float)((float)Minecraft.func_71410_x().field_71439_g.field_70163_u), (float)((float)Minecraft.func_71410_x().field_71439_g.field_70161_v)));
                }
            });
        }
    }

    @SubscribeEvent
    public void renderTickEvent(RenderGameOverlayEvent.Post event) {
        if (!this.config.isEnabled() || !event.type.equals((Object)RenderGameOverlayEvent.ElementType.ALL)) {
            return;
        }
        if (this.timeForBreak || Minecraft.func_71410_x().field_71462_r instanceof ConfigGui) {
            GlStateManager.func_179094_E();
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int corner = this.config.getCorner();
            double width = 64.0;
            double height = 64.0;
            GlStateManager.func_179098_w();
            double v = 4000.0;
            long l = System.currentTimeMillis() % (long)((int)v);
            double per = (double)l / v;
            float animationFactor = (float)((1.0 - Math.cos(per * Math.PI * 2.0)) / 2.0);
            width += (double)animationFactor * width * 0.25;
            height += (double)animationFactor * height * 0.25;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textureLoc);
            switch (corner) {
                case 2: {
                    GlStateManager.func_179137_b((double)((double)scaledResolution.func_78326_a() - width / (double)scaledResolution.func_78325_e()), (double)0.0, (double)0.0);
                    break;
                }
                case 3: {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)scaledResolution.func_78328_b() - height / (double)scaledResolution.func_78325_e()), (double)0.0);
                    break;
                }
                case 4: {
                    GlStateManager.func_179137_b((double)((double)scaledResolution.func_78326_a() - width / (double)scaledResolution.func_78325_e()), (double)((double)scaledResolution.func_78328_b() - height / (double)scaledResolution.func_78325_e()), (double)0.0);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)(0.4 + 0.6 * (double)animationFactor)));
            GlStateManager.func_179139_a((double)(1.0 + 0.25 * (double)animationFactor), (double)(1.0 + 0.25 * (double)animationFactor), (double)0.0);
            Gui.func_152125_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)16, (int)16, (float)128.0f, (float)128.0f);
            GlStateManager.func_179121_F();
        } else if (this.breaking) {
            int totalTime = 20 * this.config.getDuration();
            double percent = (double)this.breakTicks / (double)totalTime;
            ScaledResolution current = new ScaledResolution(Minecraft.func_71410_x());
            float radius = (float)current.func_78328_b() * 2.0f / 5.0f;
            int centerY = current.func_78328_b() / 2;
            int centerX = current.func_78326_a() / 2;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179090_x();
            GlStateManager.func_179112_b((int)770, (int)771);
            GL11.glEnable((int)2848);
            GL11.glHint((int)3152, (int)4354);
            GL11.glBegin((int)6);
            GlStateManager.func_179117_G();
            GL11.glVertex3d((double)centerX, (double)centerY, (double)0.0);
            float startTheta = 0.0f;
            float endTheta = (float)Math.PI * 2;
            float diff = endTheta - startTheta;
            int i = 150;
            for (float j = 0.0f; j <= (float)i; j += 1.0f) {
                Color tmp = new Color(97, 132, 249, percent > (double)(j / (float)i) ? 50 : 255);
                GlStateManager.func_179131_c((float)((float)tmp.getRed() / 255.0f), (float)((float)tmp.getGreen() / 255.0f), (float)((float)tmp.getBlue() / 255.0f), (float)((float)tmp.getAlpha() / 255.0f));
                float x = (float)centerX + radius * MathHelper.func_76126_a((float)(startTheta + diff * j / (float)i));
                float y = (float)centerY + radius * MathHelper.func_76134_b((float)(startTheta + diff * j / (float)i));
                GL11.glVertex2f((float)x, (float)y);
            }
            GL11.glEnd();
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GL11.glDisable((int)2848);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ConfigGui.drawScaledText(String.valueOf((this.config.getDuration() * 20 - this.breakTicks) / 20), centerX, centerY - 10, 2.0, Color.YELLOW.getRGB(), true, true);
            ConfigGui.drawScaledText("Press " + Keyboard.getKeyName((int)this.keyBinding.func_151463_i()) + " to cancel. ", current.func_78326_a() / 2, 5, 2.0, Color.WHITE.getRGB(), true, true);
            GlStateManager.func_179121_F();
        }
    }
}

